<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgreementsTable extends Migration {

	public function up()
	{
		Schema::create('agreements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customerId')->unsigned();
			$table->string('adminFirstName');
			$table->string('adminLastName');
			$table->string('adminEmail');
			$table->string('adminPhone');
			$table->timestamp('startDate');
			$table->timestamp('endDate');
			$table->string('paymentType');
			$table->integer('accountNumber');
			$table->string('fundingSource');
			$table->string('signature');
			$table->string('signatureAuthorized');
			$table->text('scopeOfWork');
			$table->integer('serviceId')->unsigned();
			$table->integer('userId')->unsigned();
			$table->integer('helpSpotTicketID');
			$table->integer('formStackId');
			$table->integer('scopeFileId')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('agreements');
	}
}