<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstimatesTable extends Migration {

	public function up()
	{
		Schema::create('estimates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('agreementEstimateId')->unsigned();
			$table->integer('serviceItemId')->unsigned();
			$table->integer('discountId')->unsigned();
			$table->text('notes');
			$table->enum('frequency', array('hourly', 'monthly', 'fixed'));
			$table->float('frequencyTotal');
			$table->string('percentageEffort');
			$table->float('amount');
		});
	}

	public function down()
	{
		Schema::drop('estimates');
	}
}