<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobOrdersTable extends Migration {

	public function up()
	{
		Schema::create('job_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->integer('employee_id')->nullable();
			$table->integer('vendor_id');
			$table->integer('location_id');
			$table->integer('added_by')->nullable();
			$table->integer('piroirty_id')->nullable();
			$table->integer('building_id');
			$table->integer('damage_id');
			$table->text('customer_remark')->nullable();
			$table->text('technical_remark')->nullable();
			$table->integer('type_id')->default('0');
			$table->integer('category_id');
			$table->date('detected_date')->nullable();
			$table->time('detected_time')->nullable();
			$table->date('date_completed')->nullable();
			$table->date('date_end_from_employee')->nullable();
			$table->text('text')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('job_orders');
	}
}