<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBuildingsTable extends Migration {

	public function up()
	{
		Schema::create('buildings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('name_en');
			$table->smallInteger('activity')->default('0');
			$table->smallInteger('type')->default('0');
			$table->integer('vendor_id');
			$table->integer('location_id');
			$table->integer('user_id');
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('buildings');
	}
}