<?php

namespace App\models;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;
	protected $fillable = array('vendor_id', 'name', 'name_en', 'activity', 'user_id', 'expired');

	public function vendor()
	{
		return $this->belongsTo('App\models\Vendor');
	}

	public function buildings()
	{
		return $this->hasMany('App\models\Building');
	}

	public function jobOrders()
	{
		return $this->hasMany('App\models\JobOrder');
	}

}