<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('name_en');
			$table->string('img', 300);
			$table->string('phone');
			$table->string('email');
			$table->text('text')->nullable();
			$table->text('response')->nullable();
			$table->string('user_id');
			$table->smallInteger('activity')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}