<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'img', 'content', 'category_id');

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

}