<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content', 'donation_request_id', 'client_id');

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function donationRequest()
	{
		return $this->belongsTo('App\Models\Donationrequest');
	}

}