<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyTable extends Migration {

	public function up()
	{
		Schema::create('property', function(Blueprint $table) {
			$table->increments('id');
			$table->string('unique_id')->nullable();
			$table->integer('seller_id')->unsigned()->index();
			$table->string('title')->nullable();
			$table->enum('living_type', array('Residential', 'Commercial', 'Land'));
			$table->enum('rent_sale', array('Rent', 'Sale'));
			$table->integer('property_type_id')->unsigned()->index();
			$table->float('price', 8,2);
			$table->integer('no_of_beds');
			$table->integer('no_of_baths')->default('0');
			$table->float('area_size_value', 8,2)->default('0');
			$table->integer('area_unit_id')->unsigned()->index();
			$table->string('location')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->string('image')->nullable();
			$table->longText('description')->nullable();
			$table->integer('no_of_parking_space')->default('0');
			$table->string('built_year')->nullable();
			$table->enum('status', array('Active', 'Inactive', 'Booked', 'Available', 'NotAvailable'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property');
	}
}