<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('seller_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('seller_profile')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->foreign('property_type_id')->references('id')->on('property_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->foreign('area_unit_id')->references('id')->on('area_unit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property_images', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('property')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('seller_profile', function(Blueprint $table) {
			$table->dropForeign('seller_profile_user_id_foreign');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->dropForeign('property_seller_id_foreign');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->dropForeign('property_property_type_id_foreign');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->dropForeign('property_area_unit_id_foreign');
		});
		Schema::table('property_images', function(Blueprint $table) {
			$table->dropForeign('property_images_property_id_foreign');
		});
	}
}