<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SellerProfileModel extends Model 
{

    protected $table = 'seller_profile';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\Users', 'user_id');
    }

    public function properties()
    {
        return $this->hasMany('App\PropertyModel', 'seller_id');
    }

}