<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellerProfileTable extends Migration {

	public function up()
	{
		Schema::create('seller_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('business_name')->nullable();
			$table->string('business_email')->nullable();
			$table->string('address')->nullable();
			$table->string('business_phone')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('seller_profile');
	}
}