<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'password');
	protected $hidden = array('password');

	public function neighborhoods()
	{
		return $this->belongsToMany('App\Models\Neighborhood');
	}

	public function cities()
	{
		return $this->belongsToMany('App\Models\City');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment');
	}

	public function cart()
	{
		return $this->hasOne('App\Models\Cart');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

}