<?php

namespace App\Models;

class Food extends Eloquent {

	protected $table = 'foods';
	public $timestamps = true;
	protected $fillable = array('food_image', 'name', 'description', 'price', 'timeReady');

	public function offer()
	{
		return $this->hasOne('App\Models\Offer');
	}

	public function resturants()
	{
		return $this->belongsToMany('App\Models\Resturant');
	}

	public function carts()
	{
		return $this->belongsToMany('App\Models\Cart');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

}