<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('payment', array('cash', 'visa'));
			$table->integer('total_price');
			$table->string('delivery_address');
			$table->text('note')->nullable();
			$table->integer('no_order')->unique()->unsigned();
			$table->enum('status', array('pending', 'accepted', 'rejected', 'delivered', 'declined'));
			$table->integer('resturant_id')->unique()->unsigned();
			$table->integer('food_id')->unique()->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}