<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('price')->nullable();
			$table->string('image')->nullable();
			$table->datetime('start_at')->nullable();
			$table->tinyInteger('online')->nullable()->default('1');
			$table->string('schedule')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}