<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarathonsTable extends Migration {

	public function up()
	{
		Schema::create('marathons', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->datetime('start_at');
			$table->string('duration');
			$table->string('title');
			$table->text('description')->nullable();
			$table->tinyInteger('online')->default('1');
			$table->smallInteger('price')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('marathons');
	}
}