<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlockTextsTable extends Migration {

	public function up()
	{
		Schema::create('block_texts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('block_page_id')->unsigned();
			$table->string('title_first')->nullable();
			$table->string('block_title', 255);
			$table->text('block_description');
			$table->text('images')->nullable();
			$table->enum('block_position', array('center', 'right'));
			$table->string('block_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('block_texts');
	}
}