<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommitteesTable extends Migration {

	public function up()
	{
		Schema::create('committees', function(Blueprint $table) {
			$table->bigInteger('id', true)->primary();
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->boolean('status')->default(1);
			$table->text('specialties')->nullable();
			$table->text('tasks')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('committees');
	}
}