<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('CampDocuments', function(Blueprint $table) {
			$table->foreign('camp_id')->references('id')->on('Camps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Participants', function(Blueprint $table) {
			$table->foreign('camp_id')->references('id')->on('Camps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CampFeedback', function(Blueprint $table) {
			$table->foreign('camp_id')->references('id')->on('Camps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CampFeedback', function(Blueprint $table) {
			$table->foreign('attendance_id')->references('id')->on('Attendances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attendances', function(Blueprint $table) {
			$table->foreign('participant_id')->references('id')->on('Camps')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attendances', function(Blueprint $table) {
			$table->foreign('camp_day_id')->references('id')->on('CampDays')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('CampDocuments', function(Blueprint $table) {
			$table->dropForeign('CampDocuments_camp_id_foreign');
		});
		Schema::table('Participants', function(Blueprint $table) {
			$table->dropForeign('Participants_camp_id_foreign');
		});
		Schema::table('CampFeedback', function(Blueprint $table) {
			$table->dropForeign('CampFeedback_camp_id_foreign');
		});
		Schema::table('CampFeedback', function(Blueprint $table) {
			$table->dropForeign('CampFeedback_attendance_id_foreign');
		});
		Schema::table('Attendances', function(Blueprint $table) {
			$table->dropForeign('Attendances_participant_id_foreign');
		});
		Schema::table('Attendances', function(Blueprint $table) {
			$table->dropForeign('Attendances_camp_day_id_foreign');
		});
	}
}