<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->integer('client_id')->unsigned()->nullable();
			$table->integer('campaign_id')->unsigned()->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('assigned_to')->unsigned();
			$table->date('due_date');
			$table->integer('frozen_by')->unsigned();
			$table->text('description');
			$table->string('attachments', 255);
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}