<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->enum('status', array('Pending', 'Active', 'Suspended', 'Cancelled'));
			$table->tinyInteger('reporting_day');
			$table->integer('account_manager')->unsigned();
			$table->string('logo_file', 255);
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}