<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('position')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('departments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('account_manager')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_contact', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('campaign_manager_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('client_lead_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('digital_strategist_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('campaign_type_id')->references('id')->on('campaign_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('assigned_to')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('frozen_by')->references('id')->on('requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_type_fields', function(Blueprint $table) {
			$table->foreign('campaign_type_id')->references('id')->on('campaign_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_type_values', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_type_values', function(Blueprint $table) {
			$table->foreign('campaign_type_field_id')->references('id')->on('campaign_type_fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('sent_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_emails', function(Blueprint $table) {
			$table->foreign('client_contact_id')->references('id')->on('client_contact')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_department_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_position_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_manager_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_parent_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_account_manager_foreign');
		});
		Schema::table('client_contact', function(Blueprint $table) {
			$table->dropForeign('client_contact_client_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_author_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_parent_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_client_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_campaign_manager_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_client_lead_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_digital_strategist_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_campaign_type_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_client_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_campaign_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_created_by_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_assigned_to_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_frozen_by_foreign');
		});
		Schema::table('campaign_type_fields', function(Blueprint $table) {
			$table->dropForeign('campaign_type_fields_campaign_type_id_foreign');
		});
		Schema::table('campaign_type_values', function(Blueprint $table) {
			$table->dropForeign('campaign_type_values_campaign_id_foreign');
		});
		Schema::table('campaign_type_values', function(Blueprint $table) {
			$table->dropForeign('campaign_type_values_campaign_type_field_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_campaign_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_sent_by_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_client_id_foreign');
		});
		Schema::table('client_emails', function(Blueprint $table) {
			$table->dropForeign('client_emails_client_contact_id_foreign');
		});
	}
}