<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function requestCampaign()
	{
		return $this->hasOne('Campaign', 'campaign_id');
	}

	public function requestClient()
	{
		return $this->hasOne('Client', 'client_id');
	}

	public function requestAssignedTo()
	{
		return $this->hasOne('User', 'assigned_to');
	}

	public function requestCreatedBy()
	{
		return $this->hasOne('User', 'created_by');
	}

}