<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userDepartment()
	{
		return $this->hasOne('Department', 'department_id');
	}

	public function userRole()
	{
		return $this->hasOne('Position', 'role_id');
	}

}