<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportsTable extends Migration {

	public function up()
	{
		Schema::create('reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('campaign_id')->unsigned();
			$table->integer('sent_by')->unsigned();
			$table->date('due_date');
			$table->date('sent_date')->nullable();
			$table->enum('status', array('notsent', 'sent'));
			$table->string('url', 255);
		});
	}

	public function down()
	{
		Schema::drop('reports');
	}
}