<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function clientContacts()
	{
		return $this->hasMany('ClientContact', 'client_id');
	}

	public function clientNotes()
	{
		return $this->hasMany('Note', 'parent_id');
	}

	public function clientCampaigns()
	{
		return $this->hasMany('Campaign', 'client_id');
	}

	public function clientAccountManager()
	{
		return $this->hasOne('User', 'user_id');
	}

}