<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userDepartment()
    {
        return $this->hasOne('Department', 'department_id');
    }

    public function userRole()
    {
        return $this->hasOne('Position', 'role_id');
    }

}