<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Request extends Model 
{

    protected $table = 'requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function requestCampaign()
    {
        return $this->hasOne('Campaign', 'campaign_id');
    }

    public function requestClient()
    {
        return $this->hasOne('Client', 'client_id');
    }

    public function requestAssignedTo()
    {
        return $this->hasOne('User', 'assigned_to');
    }

    public function requestCreatedBy()
    {
        return $this->hasOne('User', 'created_by');
    }

}