<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pupil extends Eloquent {

	protected $table = 'pupils';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'admno', 'admdate', 'dateofbirth', 'parent_id', 'branch_id', 'created_by', 'updated_by');
	protected $visible = array('admno', 'admdate', 'dateofbirth', 'branch_id');

	public function branch()
	{
		return $this->belongsTo('App\Branch');
	}

	public function parent()
	{
		return $this->belongsTo('Parent');
	}

}