<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Performance extends Eloquent {

	protected $table = 'performances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('classpupil_id', 'subject_id', 'class_id', 'teacher_id', 'test_id', 'branch_id', 'term_id');
	protected $visible = array('classpupil_id', 'subject_id', 'class_id', 'teacher_id', 'test_id', 'branch_id', 'term_id');

	public function classpupil()
	{
		return $this->belongsTo('Classpupil');
	}

	public function subject()
	{
		return $this->belongsTo('Subject');
	}

	public function class()
	{
		return $this->belongsTo('App\Class');
	}

	public function test()
	{
		return $this->belongsTo('Test');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function branch()
	{
		return $this->belongsTo('Branch');
	}

	public function term()
	{
		return $this->belongsTo('Term');
	}

}