<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TeacherSubject extends Eloquent {

	protected $table = 'teacherSubjects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('teacher_id', 'subject_id', 'class_id');
	protected $visible = array('teacher_id', 'subject_id', 'class_id');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function class()
	{
		return $this->belongsTo('Class');
	}

	public function subject()
	{
		return $this->belongsTo('Subject');
	}

}