<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'username', 'password', 'role_id');
	protected $visible = array('name', 'email', 'username', 'role_id');
	protected $hidden = array('password');

	public function role()
	{
		return $this->belongsTo('Role');
	}

}