<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeacherSubject extends Model 
{

    protected $table = 'teacherSubjects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('teacher_id', 'subject_id', 'class_id');
    protected $visible = array('teacher_id', 'subject_id', 'class_id');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function class()
    {
        return $this->belongsTo('Class');
    }

    public function subject()
    {
        return $this->belongsTo('Subject');
    }

}