<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pupil extends Model 
{

    protected $table = 'pupils';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'admno', 'admdate', 'dateofbirth', 'parent_id', 'branch_id', 'created_by', 'updated_by');
    protected $visible = array('admno', 'admdate', 'dateofbirth', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('App\Branch');
    }

    public function parent()
    {
        return $this->belongsTo('Parent');
    }

}