<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNetworkApiCredentialsTable extends Migration {

	public function up()
	{
		Schema::create('network_api_credentials', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('network_id')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->string('access_token');
			$table->string('account_id');
			$table->string('app_id');
			$table->string('api_key');
			$table->tinyInteger('Status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('network_api_credentials');
	}
}