<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePerformanceMatricesTable extends Migration {

	public function up()
	{
		Schema::create('performance_matrices', function(Blueprint $table) {
			$table->increments('id', true);
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('network_id')->unsigned();
			$table->integer('campaign_id')->unsigned();
			$table->integer('ad_set_id')->unsigned();
			$table->integer('ad_id')->unsigned();
			$table->string('spend');
			$table->integer('impressions');
			$table->integer('clicks');
			$table->integer('reported_installs');
			$table->date('date');
			$table->decimal('ctr', 5,2);
			$table->decimal('cpc', 10,2);
			$table->decimal('cpi', 10,2);
			$table->integer('d1_retained');
			$table->integer('d7_retained');
			$table->integer('d30_retained');
			$table->decimal('cpd1', 10,2);
			$table->decimal('cpd7', 10,2);
			$table->decimal('cpd30', 10,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('performance_matrices');
	}
}