<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('network_api_credentials', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->foreign('network_id')->references('id')->on('networks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->foreign('ad_set_id')->references('id')->on('ad_sets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->foreign('ad_id')->references('id')->on('ads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('network_id')->references('id')->on('networks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ad_sets', function(Blueprint $table) {
			$table->foreign('network_id')->references('id')->on('networks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ad_sets', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('network_id')->references('id')->on('networks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('ad_set_id')->references('id')->on('ad_sets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('network_api_credentials', function(Blueprint $table) {
			$table->dropForeign('network_api_credentials_customer_id_foreign');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->dropForeign('performance_matrices_customer_id_foreign');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->dropForeign('performance_matrices_network_id_foreign');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->dropForeign('performance_matrices_campaign_id_foreign');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->dropForeign('performance_matrices_ad_set_id_foreign');
		});
		Schema::table('performance_matrices', function(Blueprint $table) {
			$table->dropForeign('performance_matrices_ad_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_network_id_foreign');
		});
		Schema::table('ad_sets', function(Blueprint $table) {
			$table->dropForeign('ad_sets_network_id_foreign');
		});
		Schema::table('ad_sets', function(Blueprint $table) {
			$table->dropForeign('ad_sets_campaign_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_network_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_ad_set_id_foreign');
		});
	}
}