<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClearanceOfficesTable extends Migration {

	public function up()
	{
		Schema::create('clearance_offices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->string('email', 191)->nullable();
			$table->string('mobile_number', 191)->nullable();
			$table->string('telephone_number', 191)->nullable();
			$table->string('license_number', 191)->nullable();
			$table->string('license_expired', 191)->nullable();
			$table->string('license_copy', 191)->nullable();
			$table->string('cr_number', 191)->nullable();
			$table->string('cr_copy', 191)->nullable();
			$table->string('cr_expired', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('Country')->unsigned()->nullable();
			$table->bigInteger('city_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clearance_offices');
	}
}