<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingModesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_modes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('shipping_modes');
	}
}