<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191)->nullable();
			$table->string('name_en', 191)->nullable();
			$table->tinyInteger('acitve')->default('1');
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}