<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entity_user', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('entity_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('position_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('position_user', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unit_performances', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->foreign('taxonomy_id')->references('id')->on('taxonomies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->foreign('taxonomy_status_type_id')->references('id')->on('taxonomies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->foreign('workflow_id')->references('id')->on('workflows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->foreign('taxonomy_submit_status_id')->references('id')->on('taxonomies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->foreign('taxonomy_reject_status_id')->references('id')->on('taxonomies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_assignment_executors', function(Blueprint $table) {
			$table->foreign('project_assignment_id')->references('id')->on('project_assignments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('entity_user', function(Blueprint $table) {
			$table->dropForeign('entity_user_entity_id_foreign');
		});
		Schema::table('entity_user', function(Blueprint $table) {
			$table->dropForeign('entity_user_user_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_entity_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_group_id_foreign');
		});
		Schema::table('position_user', function(Blueprint $table) {
			$table->dropForeign('position_user_user_id_foreign');
		});
		Schema::table('position_user', function(Blueprint $table) {
			$table->dropForeign('position_user_position_id_foreign');
		});
		Schema::table('unit_performances', function(Blueprint $table) {
			$table->dropForeign('unit_performances_entity_id_foreign');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->dropForeign('project_assignments_project_id_foreign');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->dropForeign('project_assignments_entity_id_foreign');
		});
		Schema::table('project_assignments', function(Blueprint $table) {
			$table->dropForeign('project_assignments_workflow_id_foreign');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->dropForeign('workflows_taxonomy_id_foreign');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->dropForeign('workflows_taxonomy_status_type_id_foreign');
		});
		Schema::table('workflows', function(Blueprint $table) {
			$table->dropForeign('workflows_group_id_foreign');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->dropForeign('workflow_steps_workflow_id_foreign');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->dropForeign('workflow_steps_taxonomy_submit_status_id_foreign');
		});
		Schema::table('workflow_steps', function(Blueprint $table) {
			$table->dropForeign('workflow_steps_taxonomy_reject_status_id_foreign');
		});
		Schema::table('project_assignment_executors', function(Blueprint $table) {
			$table->dropForeign('project_assignment_executors_project_assignment_id_foreign');
		});
	}
}