<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePositionsTable extends Migration {

	public function up()
	{
		Schema::create('positions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26);
			$table->string('code', 50)->nullable()->index();
			$table->string('name')->index();
			$table->string('description')->nullable();
			$table->bigInteger('entity_id')->unsigned();
			$table->char('entity_ulid', 26);
			$table->bigInteger('group_id')->unsigned()->index();
			$table->string('status', 20)->default('active');
			$table->jsonb('properties')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('positions');
	}
}