<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->char('ulid', 26)->unique();
			$table->string('code', 50)->nullable();
			$table->string('name', 150);
			$table->string('description')->nullable();
			$table->integer('group_id')->unsigned()->index()->default('0');
			$table->integer('period_id')->unsigned()->index();
			$table->integer('taxonomy_id')->unsigned()->index();
			$table->integer('criteria_id')->unsigned()->index();
			$table->text('tags')->nullable();
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}