<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitPerformancesTable extends Migration {

	public function up()
	{
		Schema::create('unit_performances', function(Blueprint $table) {
			$table->increments('id');
			$table->char('ulid', 26);
			$table->bigInteger('entity_id')->unsigned()->index();
			$table->char('entity_ulid', 26);
			$table->string('name')->index();
			$table->string('description')->nullable();
			$table->integer('group_id')->default('0');
			$table->jsonb('properties')->nullable();
			$table->string('status', 20)->default('active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('unit_performances');
	}
}