<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProduitsTable extends Migration {

	public function up()
	{
		Schema::create('produits', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom_produits', 255);
			$table->string('prix_produit', 255);
			$table->string('description_produit', 255);
			$table->integer('categorie_id')->unsigned()->index();
			$table->string('image_produit', 255);
			$table->bigInteger('quantiter_stock');
		});
	}

	public function down()
	{
		Schema::drop('produits');
	}
}