<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type');
			$table->string('page_url');
			$table->integer('initial_likes_count')->unsigned();
			$table->integer('required_likes_count')->unsigned();
			$table->integer('payment_chip');
			$table->integer('owner_id')->unsigned();
			$table->timestamp('approved_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}