<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('spcial_offer', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('spcial_offer_product', function(Blueprint $table) {
			$table->foreign('spcial_offer_id')->references('id')->on('spcial_offer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('spcial_offer_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_cart_id_foreign');
		});
		Schema::table('cart_product', function(Blueprint $table) {
			$table->dropForeign('cart_product_product_id_foreign');
		});
		Schema::table('spcial_offer', function(Blueprint $table) {
			$table->dropForeign('spcial_offer_product_id_foreign');
		});
		Schema::table('spcial_offer_product', function(Blueprint $table) {
			$table->dropForeign('spcial_offer_product_spcial_offer_id_foreign');
		});
		Schema::table('spcial_offer_product', function(Blueprint $table) {
			$table->dropForeign('spcial_offer_product_product_id_foreign');
		});
	}
}