<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('product_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('store_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('description')->nullable();
			$table->boolean('is_active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('product_categories');
	}
}