<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('stock_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('store_id')->unsigned();
			$table->integer('outlet_id')->unsigned()->nullable();
			$table->integer('product_id')->unsigned();
			$table->integer('variant_id')->unsigned()->nullable();
			$table->enum('type', array('IN', 'OUT'));
			$table->integer('quantity');
			$table->string('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stock_transactions');
	}
}